/*** 1.   ũƮ ***/
SELECT number id 
	, CASE WHEN number <= 50 THEN 1 ELSE 2 END gid
	, DATEADD(dd,number, '2020-01-01') date 
INTO  TB_CAFirst
FROM master..spt_values
WHERE type = 'P'
AND number BETWEEN 1 AND 100
GO

ALTER TABLE TB_CAFirst ADD CONSTRAINT PK_CAFirst PRIMARY KEY(id)
GO

WITH w_values AS
	(SELECT number 
	FROM master..spt_values
	WHERE type = 'P'
	AND number BETWEEN 1 AND 100)
SELECT a.number id
	, DATEADD(dd,B.number,'2020-01-01') date
	, NEWID() code INTO TB_CASecond
FROM w_values a, w_values b, w_values c 
GO

ALTER TABLE TB_CASecond ADD CONSTRAINT FK_CASecond FOREIGN KEY (ID) 
	REFERENCES TB_CAFirst (ID)
GO

CREATE INDEX NIDX01_CAFirst ON TB_CAFirst ( gid) INCLUDE (id)
CREATE INDEX NIDX01_CASecond ON TB_CASecond (id,date) INCLUDE (code)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT id, code, date
FROM (SELECT f.id
	      , s.code
	      , s.date
	      , ROW_NUMBER() OVER ( PARTITION BY s.id ORDER BY s.date DESC) rn
	 FROM TB_CAFirst f 
	 INNER  JOIN TB_CASecond s
	 ON f.id = s.id 
	 WHERE f.gid = 1
) a
WHERE a.rn <= 5
GO


/*** 6. [TO-BE]   ***/

SELECT f.id, s.code,s.date
FROM TB_CAFirst f CROSS APPLY (SELECT TOP 5 code,date
                               FROM TB_CASecond s 
                               WHERE f.id = s.id
                               ORDER BY date DESC) s 
WHERE f.gid = 1
GO



